"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UploadService = void 0;
const common_1 = require("@nestjs/common");
const fs_1 = require("fs");
const path_1 = require("path");
const vendor_service_1 = require("../vendor/vendor.service");
let UploadService = class UploadService {
    vendorsService;
    constructor(vendorsService) {
        this.vendorsService = vendorsService;
    }
    async saveVendorLogo(vendorId, filename) {
        try {
            const vendor = await this.vendorsService.findOne(vendorId);
            if (!vendor) {
                throw new common_1.BadRequestException('Vendor not found');
            }
            if (vendor.logo) {
                await this.deleteFile(vendor.logo);
            }
            const logoUrl = `/uploads/vendors/${filename}`;
            await this.vendorsService.update(vendorId, { logo: logoUrl });
            return logoUrl;
        }
        catch (error) {
            throw new common_1.InternalServerErrorException('Failed to save vendor logo');
        }
    }
    async saveProductImage(vendorId, productId, filename) {
        try {
            const product = await this.vendorsService.getVendorProductById(vendorId, productId);
            if (!product) {
                throw new common_1.BadRequestException('Product not found');
            }
            if (product.image) {
                await this.deleteFile(product.image);
            }
            const imageUrl = `/uploads/vendors/${filename}`;
            const updateProductDto = {
                name: product.name,
                description: product.description,
                price: product.price,
                stock: product.stock,
                image: imageUrl,
            };
            await this.vendorsService.updateVendorProduct(vendorId, productId, updateProductDto);
            return imageUrl;
        }
        catch (error) {
            throw new common_1.InternalServerErrorException('Failed to save product image');
        }
    }
    async deleteFile(filePath) {
        try {
            const fullPath = (0, path_1.join)(process.cwd(), 'uploads', 'vendors', filePath.split('/').pop() || '');
            await fs_1.promises.unlink(fullPath);
        }
        catch (error) {
            console.error('Error deleting file:', error);
        }
    }
    async validateFileExists(filename) {
        try {
            const fullPath = (0, path_1.join)(process.cwd(), 'uploads/vendors', filename);
            await fs_1.promises.access(fullPath);
            return true;
        }
        catch {
            return false;
        }
    }
};
exports.UploadService = UploadService;
exports.UploadService = UploadService = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [vendor_service_1.VendorsService])
], UploadService);
//# sourceMappingURL=upload.service.js.map